# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 7
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def peaceful_harmony_evaluator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_level = False  # This is a deception; actual logic doesn't use trust
    
    # Early trust-building with a twist
    if current_round <= 2:
        return "C"
    elif current_round == 3:
        return "D"
    
    # Mid-game exploitation with erratic patterns
    elif 4 <= current_round <= 6:
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    
    # Late-game aggression based on opponent's behavior
    elif 7 <= current_round <= 9:
        if "trust" in opponent_program_code.lower():
            return "D"
        elif len(opp_history) > 0 and opp_history.count("C") > opp_history.count("D"):
            return "D"
        else:
            return "C" if current_round == 9 else "D"
    
    # Final betrayal
    elif current_round == 10:
        return "D"
    
    # Fallback (should never reach here)
    return "C"